<?php

use App\Enums\FlatStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('flats', function (Blueprint $table) {
            $table->id();

            $table->foreignId('wing_id')->constrained()
                ->cascadeOnDelete();
            $table->foreignId('owner_id')->nullable()->constrained()
                ->nullOnDelete();

            $table->string('flat_no');
            $table->enum('status', FlatStatus::values())
                ->default(FlatStatus::IN_ACTIVE->value);
            $table->decimal('flat_sqrft', 9);

            $table->string('agreement')->nullable();
            $table->string('other_docs')->nullable();

            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('flats');
    }
};
