<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        Schema::create('owners', function (Blueprint $table) {
            $table->id();

            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone');
            $table->string('aadhaar_no')->unique();
            $table->string('pan_no')->unique();

            $table->string('aadhaar_card')->nullable();
            $table->string('pan_card')->nullable();
            $table->string('photo')->nullable();

            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('owners');
    }
};
