<?php

namespace App\Http\Requests\VehicleLog;

use App\Enums\VehicleLogType;
use App\Http\Requests\BaseRequest;

class UpdateVehicleLogRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'vehicle_id' => 'sometimes|nullable|exists:vehicles,id',
            'guard_id' => 'sometimes|exists:users,id',
            'log_type' => 'sometimes|in:' . implode(',', VehicleLogType::values()),
            'logged_at' => 'sometimes|date',
            'purpose' => 'sometimes|nullable|string|max:255',
            'visitor_details' => 'sometimes|nullable|array',
            'visitor_details.name' => 'sometimes|nullable|string|max:255',
            'visitor_details.phone' => 'sometimes|nullable|string|max:20',
            'visitor_details.purpose' => 'sometimes|nullable|string|max:255',
            'outsider_vehicle_details' => 'sometimes|nullable|array',
            'outsider_vehicle_details.vehicle_type' => 'sometimes|nullable|string|max:255',
            'outsider_vehicle_details.make' => 'sometimes|nullable|string|max:255',
            'outsider_vehicle_details.model' => 'sometimes|nullable|string|max:255',
            'outsider_vehicle_details.color' => 'sometimes|nullable|string|max:255',
            'outsider_vehicle_details.registration_no' => 'sometimes|nullable|string|max:255',
        ];
    }
}
