<?php

namespace App\Http\Resources;

use App\Models\Vehicle;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin Vehicle */
class VehicleResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'vehicle_type' => $this->vehicle_type,
            'make' => $this->make,
            'model' => $this->model,
            'color' => $this->color,
            'registration_no' => $this->registration_no,
            'unique_code' => $this->unique_code,
            'photo' => $this->photo,
            'insurance_doc' => $this->insurance_doc,
            'is_active' => $this->is_active,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,

            'owner_id' => $this->owner_id,
            'flat_id' => $this->flat_id,

            'owner' => new OwnerResource($this->whenLoaded('owner')),
            'flat' => new FlatResource($this->whenLoaded('flat')),
        ];
    }
}