<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Flat extends Model
{
    use HasFactory;

    protected $fillable = [
        'wing_id',
        'owner_id',
        'flat_no',
        'status',
        'flat_sqrft',
        'agreement',
        'other_docs',
    ];

    public function wing(): BelongsTo {
        return $this->belongsTo(Wing::class);
    }

    public function owner(): BelongsTo {
        return $this->belongsTo(Owner::class);
    }
}
