<?php

namespace App\Http\Requests\Vehicle;

use App\Http\Requests\BaseRequest;
use App\Enums\VehicleType;
use Illuminate\Validation\Rule;

class StoreVehicleRequest extends BaseRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'owner_id' => ['required', 'exists:owners,id'],
            'flat_id' => ['required', 'exists:flats,id'],
            'vehicle_type' => ['required', Rule::enum(VehicleType::class)],
            'make' => ['required', 'string', 'max:255'],
            'model' => ['required', 'string', 'max:255'],
            'color' => ['required', 'string', 'max:255'],
            'registration_no' => ['required', 'string', 'max:255', 'unique:vehicles,registration_no'],
            'photo' => $this->validateFile('photo'),
            'insurance_doc' => $this->validateFile('insurance_doc'),
            'is_active' => ['boolean'],
        ];
    }
}