<?php

use App\Enums\DailyPatrolSummaryStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('daily_patrol_summaries', function (Blueprint $table) {
            $table->id();

            $table->foreignId('patrol_round_id')->constrained('patrol_rounds')->onDelete('cascade');
            $table->foreignId('guard_id')->constrained('users')->onDelete('cascade');

            $table->date('patrol_date');
            $table->integer('total_locations');
            $table->integer('completed_locations');
            $table->integer('missed_locations');
            $table->time('expected_start_time')->nullable();
            $table->time('expected_end_time')->nullable();
            $table->timestamp('actual_start_time')->nullable();
            $table->timestamp('actual_end_time')->nullable();
            $table->enum('status', DailyPatrolSummaryStatus::values())->default(DailyPatrolSummaryStatus::STARTED->value);
            $table->text('notes')->nullable();

            $table->timestamps();

            $table->unique(['guard_id', 'patrol_date', 'patrol_round_id'], 'unique_guard_patrol_round');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('daily_patrol_summaries');
    }
};
