<?php

namespace App\Enums;

enum PatrollingLocationType: string
{
    case GATE = "gate";
    case GARDEN = "garden";
    case PARKING = "parking";
    case COMMON_AREA = "common_area";
    case BUILDING = "building";
    case PLAYGROUND = "playground";
    case SWIMMING_POOL = "swimming_pool";
    case GYM = "gym";
    case CLUB_HOUSE = "club_house";
    case OTHER = "other";


    /**
     * Get all patrolling location type values
     */
    public static function values(): array {
        return array_column(self::cases(), 'value');
    }
}